# -*- coding: utf-8 -*-
import os
import datetime

from mysite.sql_utils import p_query,p_execute,p_mutiexec,get_sql

log_dir = "tmp/deal_attrecord"
faild_dir = "tmp/deal_attrecord/faild"


def write_log(wstr,filename,wdir):
    try:
        if not os.path.exists(wdir):
            os.mkdir(wdir)
        mfile='%s/%s'%(wdir,filename)
        f=open(mfile,'a')
        f.write(wstr)
        f.close()
    except:
        import traceback
        traceback.print_exc()
        pass


def att_deal_logger(str):
    filename="%s.log"%datetime.datetime.now().strftime("%Y_%m")
    str = '%s: %s\n'%(datetime.datetime.now(), str)
    write_log(str,filename,log_dir)


def att_deal_faild_accord(sn,data):
    filename = "%s_%s.dat" % (datetime.datetime.now().strftime("%Y_%m"), sn)
    write_log(data, filename, faild_dir)


def save_attrecord(att_dict_list,event=True):
    '''
    保存考勤原始记录到数据库 
    realtime:
        True:  设备实时上传过来的数据
        False: 文件解析过来的数据 
    '''
    from mysite.personnel.models.model_emp import format_pin
    import time
    if att_dict_list:
        insert_sql = get_sql("sql","checkinout_insert","iclock",{},{},True)            
        batch_sql = []
        for ad in att_dict_list:
            ad["pin"] = format_pin(ad["pin"])
            batch_sql.append(insert_sql%ad) 
        success,res = p_mutiexec(batch_sql)
        if not success:
            # 出现异常,一条一条插入:
            if res and res[0]==-2:
                att_deal_logger("Insert attrecord failed ,Database has been disconnected!")
                if event <> "files":
                    time.sleep(2*60)  # 机器post 数据,如果服务器一段时间没有返回,则机器会默认为服务器没有收到,会再次post.
                return False
            
            else:
                for bs in batch_sql:
                    num = p_execute(bs)
                    if num is None:
                        att_deal_logger("Error sql -->%s"%bs)
                        if event <> "files":
                            # 设备上传数据,数据异常导致保存失败
                            time.sleep(2*60)
                        return False
                    elif num < 0:
                        return False
        return True


def line_to_log(device, lines, event=True):
    '''
    处理一批考勤记录数据
    返回 rtn 成功执行的条数
    '''
    # from comm.commen_utils import normal_state, normal_verify
    from comm.commen_utils import normal_verify
    from ooredis import Dict
    m_result=[]
    for line in lines:
        if line:
            flds = line.split("\t")
            #记录中有ngnix头信息异常,考勤记录最小字段为2个段,小于2个段的为异常记录
            #可接受最小PIN checkTime二个字段的记录
            if len(flds) < 2:   
                att_deal_logger(flds)
                continue
            else:
                try:
                    area_names = Dict('area_id_name_hash')
                    flds += ["", "", "", ""]  #防止flds[2],flds[3],flds[4],flds[5]报错
                    pin = flds[0]
                    logtime = datetime.datetime.strptime(flds[1], "%Y-%m-%d %H:%M:%S")
                    device_alias = device.alias
                    device_area_name = area_names.get(device.area)
                    if device_alias:
                        device_alias = u"{0}".format(device_alias).replace("'", "''")
                    if device_area_name:
                        device_area_name = u"{0}".format(device_area_name).replace("'", "''")
                    attrecord = {
                        "pin": pin,
                        "checktime": logtime,
                        "checktype": flds[2], #考勤状态
                        "verifycode": normal_verify(flds[3]), #验证方式
                        "WorkCode": flds[4], #工作号码
                        "Reserved": flds[5], #保留字段
                        "sn_name": device.sn,
                        "SN": device_alias,
                        "area": device.area,
                        "area_name": device_area_name,
                        "upload_time": datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
                    }
                    m_result.append(attrecord)
                except Exception,e:
                    pass
                    # import traceback
                    # traceback.print_exc()
    rtn = True
    if m_result:
        rtn = save_attrecord(m_result, event)
    return rtn